#!/bin/sh
#
# Convert an Old-Style ROCK Linux Extension to the standard package format.
#
# --- T2-COPYRIGHT-NOTE-BEGIN ---
# This copyright note is auto-generated by ./scripts/Create-CopyPatch.
# 
# T2 SDE: misc/archive/extconv.sh
# Copyright (C) 2004 - 2005 The T2 SDE Project
# Copyright (C) 1998 - 2003 ROCK Linux Project
# 
# More information can be found in the files COPYING and README.
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License. A copy of the
# GNU General Public License can be found in the file COPYING.
# --- T2-COPYRIGHT-NOTE-END ---

if [ -z "$1" -o ! -f "$1.ext" ] ; then
	[ ! -f "$1.ext" ] && echo "No such file: $1.ext"
	echo "Usage: $0 <ext-name>"
	exit 1
fi

egrep '^# +\[' $1.ext | sed 's,^# *,,' | \
egrep -v '^\[(P|PRI|PRIORITY)\]' > $1.desc

pri=`{ egrep '^# +\[(P|PRI|PRIORITY)\] +' $1.ext ; echo ". . 5" ; } | head -n 1 | tr -s ' ' | cut -f3 -d' '`
echo "[P] X ------6--9 300.$pri" >> $1.desc

{
echo "#"
echo "# Converted from $name.ext by <rock-base>/misc/archive/extconv.sh"
echo "#"
echo
echo 'if [ "$prefix" != "opt/$pkg" ] ; then'
echo '	abort "!! This package is converted from an old-style .ext file and'
echo '!! might only compile fine when built with the Build-Pkg'
echo '!! option \"-prefix /opt/$pkg\"."'
echo 'fi'
echo
echo "main() {"
egrep -v '^# +\[' $1.ext
echo "}"
echo
echo "autoextract=0"
echo "custmain=main"
echo
} > $1.conf

