#!/bin/bash
# --- T2-COPYRIGHT-NOTE-BEGIN ---
# This copyright note is auto-generated by ./scripts/Create-CopyPatch.
# 
# T2 SDE: target/psion-pda/build_image.sh
# Copyright (C) 2004 - 2005 The T2 SDE Project
# 
# More information can be found in the files COPYING and README.
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License. A copy of the
# GNU General Public License can be found in the file COPYING.
# --- T2-COPYRIGHT-NOTE-END ---

. $base/misc/target/functions.in

set -e

arlo_ver="`sed -e 's,.*arlo-\(.*\).zip .*,\1,' \
           $base/target/$target/download.txt`"

echo "Preparing root filesystem image from build result ..."

rm -rf $imagelocation{,.squashfs}
mkdir -p $imagelocation ; cd $imagelocation

find $build_root -printf "%P\n" | sed '

# stuff we never need

/^TOOLCHAIN/	d;
/^var\/adm/	d;

/\/include/	d;
/\/src/		d;
/\.a$/		d;
/\.o$/		d;
/\.old$/	d;

/\/games/	d;
/\/local/	d;
/^boot/		d;

# stuff that would be nice - but is huge and only documentation
/\/man/		d;
/\/doc/		d;

# /etc noise
/^etc\/stone.d/	d;
/^etc\/cron.d/	d;
/^etc\/init.d/	d;
/^etc\/profile.d/	d;

/^etc\/sysconfig/	d;
/^etc\/iproute2/	d;

/^etc\/skel/	d;
/^etc\/opt/	d;
/^etc\/conf/	d;
/^etc\/rc.d/	d;

/^home/		d;
/^mnt/		d;
/^opt/		d;

# rock net stuff
/^lib\/network/ d;
/^sbin\/ifup/	d;
/^sbin\/ifdown/	d;
/^sbin\/rocknet/	d;

/^\/man\//	d;

/terminfo\/a\/ansi$/	{ p; d; }
/terminfo\/l\/linux$/	{ p; d; }
/terminfo\/x\/xterm$/	{ p; d; }
/terminfo\/n\/nxterm$/	{ p; d; }
/terminfo\/x\/xterm-color$/	{ p; d; }
/terminfo\/x\/xterm-8bit$/	{ p; d; }
/terminfo\/x\/screen$/	{ p; d; }
/terminfo\/v\/vt100$/	{ p; d; }
/terminfo\/v\/vt200$/	{ p; d; }
/terminfo\/v\/vt220$/	{ p; d; }
/terminfo/	d;

# some big ncurses stuff
/\/tack$/	d;
/\/tic$/	d;
/\/toe$/	d;
/\/tput$/	d;
/\/tset$/	d;
/\/captoinfo$/	d;
/\/input$/	d;

' > tar.input

copy_with_list_from_file $build_root . $PWD/tar.input
rm tar.input

echo "Preparing root filesystem image from target defined files ..."
rm -f sbin/init ; ln -s minit sbin/init
rm -f bin/sh ; ln -s ash bin/sh
copy_from_source $base/target/$target/rootfs .

echo "Creating links for identical files ..."
link_identical_files

echo "Creating static device nodes in /dev ..."

while read trg name ; do
	ln -s $trg $name
done < <(cat <<-EOT
kcore dev/core
/proc/self/fd dev/fd
fd/0 dev/stdin
fd/1 dev/stdout
fd/2 dev/stderr
vcs0 dev/vcs
EOT
)

while read type major minor name ; do
	if [ "$name" ] ; then
		mknod dev/$name $type $major $minor
	else
		echo "defect rule!"
	fi
done < <(cat <<-EOT
c 10 3 atibm
c 14 4 audio
c 14 20 audio1
c 14 36 audio2
c 14 52 audio3
c 14 7 audioctl
c 5 1 console
c 14 3 dsp
c 14 19 dsp1
c 29 0 fb0
c 1 7 full
c 10 2 inportbm
c 161 0 ircomm0
c 161 1 ircomm1
c 161 16 irlpt0
c 161 17 irlpt1
c 10 4 jbm
c 1 2 kmem
c 10 0 logibm
b 7 0 loop0
b 7 1 loop1
b 7 2 loop2
b 7 3 loop3
c 6 0 lp0
c 6 1 lp1
c 6 2 lp2
c 1 1 mem
c 14 0 mixer
c 14 16 mixer1
c 1 3 null
c 1 4 port
c 5 2 ptmx
c 2 0 ptyp0
c 2 1 ptyp1
c 2 2 ptyp2
c 2 3 ptyp3
c 2 4 ptyp4
c 2 5 ptyp5
c 2 6 ptyp6
c 2 7 ptyp7
c 2 8 ptyp8
c 2 9 ptyp9
c 2 10 ptypa
c 2 11 ptypb
c 2 12 ptypc
c 2 13 ptypd
c 2 14 ptype
c 2 15 ptypf
b 1 0 ram0
b 1 1 ram1
b 1 2 ram2
b 1 3 ram3
c 1 8 random
c 14 6 sndstat
c 10 11 tpanel
c 5 0 tty
c 4 0 tty0
c 4 1 tty1
c 4 10 tty10
c 4 2 tty2
c 4 3 tty3
c 4 4 tty4
c 4 5 tty5
c 4 6 tty6
c 4 7 tty7
c 4 8 tty8
c 4 9 tty9
c 204 16 ttyAM0
c 204 17 ttyAM1
c 204 16 ttyS0
c 204 17 ttyS1
c 1 9 urandom
c 7 0 vcs0
c 7 1 vcs1
c 7 2 vcs2
c 7 3 vcs3
c 7 4 vcs4
c 7 5 vcs5
c 7 6 vcs6
c 7 7 vcs7
c 7 8 vcs8
c 7 9 vcs9
c 1 5 zero
EOT
)

# image size estimation ...
s="`du -s -B 1 . | cut -f 1`"
s="$(( (s + 128000) / 1024 ))"
s="$(( s * 1024 ))"

echo "Writing initrd image file ($s bytes)."

tmpdir="`mktemp`" ; rm $tmpdir ; mkdir $tmpdir
tmpfile="`mktemp`"

dd if=/dev/zero of=$tmpfile bs=$s count=1 > $tmpfile

mke2fs -m 0 -N 512 -qF $tmpfile > /dev/null
mount -t ext2 $tmpfile $tmpdir -o loop
rmdir $tmpdir/lost+found/

copy_from_source . $tmpdir

umount $tmpdir
gzip -9 -c $tmpfile > ../initrd.gz
rmdir $tmpdir ; rm -f $tmpfile

du -sh . ../initrd.gz

cd $imagelocation/..
rm -rf epoc ; mkdir epoc ; cd epoc
cp $build_root/boot/Image_* Image

echo "Extracting ARLO ..."
unzip $base/download/mirror/a/arlo-$arlo_ver.zip > /dev/null
rm arlo/{copying,readme.html,example.cfg}

cp $base/target/$target/arlo.cfg arlo/

echo "The image is located at $imagelocation/.."

