# --- T2-COPYRIGHT-NOTE-BEGIN ---
# This copyright note is auto-generated by ./scripts/Create-CopyPatch.
# 
# T2 SDE: architecture/avr32/kernel.conf.sh
# Copyright (C) 2008 The T2 SDE Project
# 
# More information can be found in the files COPYING and README.
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License. A copy of the
# GNU General Public License can be found in the file COPYING.
# --- T2-COPYRIGHT-NOTE-END ---


if [ -f .config.defconfig ]; then
	cat .config.defconfig
elif [ -f $base/architecture/$arch/kernel.conf.m4 ]; then
	m4 -I $base/architecture/$arch -I $base/architecture/share $base/architecture/$arch/kernel.conf.m4
else
	echo "# No defaults found"
fi


# too much troubles with the common kernel settings, many drivers do not
# compile cleanly ... :-(

merge_defconfig_and_t2 () {

	m4 -I $base/architecture/$arch -I $base/architecture/share $base/architecture/$arch/kernel.conf.m4 > .config.kdef
	cp .config.defconfig .config.k1

	# merge various text/plain config files
	for x in .config.k1 ; do
		if [ -f $x ] ; then
			tag="$(sed '/CONFIG_/ ! d; s,.*CONFIG_\([^ =]*\).*,\1,' $x | tr '\n' '|')"
			egrep -v "\bCONFIG_($tag)\b" < .config.kdef > .config.k2
			sed 's,\(CONFIG_.*\)=n,# \1 is not set,' $x >> .config.k2
		fi
	done

	cat .config.k2
}
